/*
 * Decompiled with CFR 0.152.
 */
package net.dragonloot.mixin;

import io.netty.buffer.Unpooled;
import net.dragonloot.access.DragonAnvilInterface;
import net.dragonloot.init.BlockInit;
import net.dragonloot.init.ConfigInit;
import net.dragonloot.network.SyncPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilScreenHandlerMixin
extends ItemCombinerMenu
implements DragonAnvilInterface {
    @Shadow
    private final DataSlot f_39002_ = DataSlot.m_39401_();
    public boolean isDragonAnvil = false;

    public AnvilScreenHandlerMixin(MenuType<?> type, int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(type, syncId, playerInventory, context);
    }

    @Inject(method={"canUse"}, at={@At(value="HEAD")})
    private void canUseMixin(BlockState state, CallbackInfoReturnable<Boolean> info) {
        if (state.m_60713_((Block)BlockInit.DRAGON_ANVIL_BLOCK)) {
            this.isDragonAnvil = true;
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            data.writeInt(this.f_39771_.m_19879_());
            data.m_130070_(state.m_60734_().toString());
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)this.f_39771_), (ResourceLocation)SyncPacket.ANVIL_SYNC_PACKET, (FriendlyByteBuf)data);
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/Property;set(I)V")}, cancellable=true)
    private void onTakeOutputMixin(Player player, ItemStack stack, CallbackInfo info) {
        if (this.isDragonAnvil) {
            this.f_39770_.m_39292_((world, blockPos) -> {
                this.f_39002_.m_6422_(0);
                world.m_46796_(1030, blockPos, 0);
                info.cancel();
            });
        }
    }

    @Inject(method={"Lnet/minecraft/screen/AnvilScreenHandler;updateResult()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/Property;set(I)V", shift=At.Shift.AFTER)})
    private void updateResultMixin(CallbackInfo info) {
        if (this.f_39002_.m_6501_() > 30 && this.isDragonAnvil && ConfigInit.CONFIG.dragon_anvil_no_cap) {
            this.f_39002_.m_6422_(30);
        }
    }

    @Inject(method={"getLevelCost"}, at={@At(value="HEAD")}, cancellable=true)
    private void getLevelCostMixin(CallbackInfoReturnable<Integer> info) {
        if (this.f_39002_.m_6501_() > 30 && this.isDragonAnvil && ConfigInit.CONFIG.dragon_anvil_no_cap) {
            info.setReturnValue((Object)30);
        }
    }

    @Override
    public void setDragonAnvil(String string) {
        if (string.equals(BlockInit.DRAGON_ANVIL_BLOCK.toString())) {
            this.isDragonAnvil = true;
        }
    }
}

